/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jeresources.collection.TradeList;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractVillagerEntry<T extends AbstractVillager> {
    private final List<TradeList> tradeList = new LinkedList<TradeList>();
    protected T entity;

    public AbstractVillagerEntry(Int2ObjectMap<VillagerTrades.ItemListing[]> itemListings) {
        this.addITradeLists(itemListings);
    }

    public AbstractVillagerEntry() {
    }

    public void addITradeLists(Int2ObjectMap<VillagerTrades.ItemListing[]> itemListings) {
        for (int i = 1; i < itemListings.size() + 1; ++i) {
            VillagerTrades.ItemListing[] levelList = (VillagerTrades.ItemListing[])itemListings.get(i);
            TradeList trades = this.tradeList.size() > i ? this.tradeList.get(i) : new TradeList(this);
            trades.addITradeList(levelList);
            this.tradeList.add(trades);
        }
    }

    public TradeList getVillagerTrades(int level) {
        if (this.tradeList.size() > level) {
            return this.tradeList.get(level);
        }
        return new TradeList(this);
    }

    public List<ItemStack> getInputs() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (List list2 : this.tradeList) {
            for (TradeList.Trade trade : list2) {
                list.add(trade.getMinCostA());
                if (trade.getMinCostB().isEmpty()) continue;
                list.add(trade.getMinCostB());
            }
        }
        return list;
    }

    public List<ItemStack> getOutputs() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (List list2 : this.tradeList) {
            list.addAll(list2.stream().map(TradeList.Trade::getMinResult).toList());
        }
        return list;
    }

    public int getMaxLevel() {
        return this.tradeList.size();
    }

    public abstract Component getDisplayName();

    public List<Integer> getPossibleLevels(IFocus<ItemStack> focus) {
        ArrayList<Integer> levels = new ArrayList<Integer>();
        for (int i = 0; i < this.tradeList.size(); ++i) {
            if (this.tradeList.get(i) == null || this.tradeList.get(i).getFocusedList(focus).size() <= 0) continue;
            levels.add(i);
        }
        return levels;
    }

    public abstract T getVillagerEntity();

    public void clearEntity() {
        this.entity = null;
    }

    public abstract List<ItemStack> getPois();

    public abstract boolean hasPois();

    public abstract boolean hasLevels();
}

